
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG12410.C - Message 1241 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1241 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1241 message from the ZMsgBuf.
//
void Dec1241(tMSGBUF *ZMsgBuf, tMSG1241 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1241 message in the ZMsgBuf.
//
void Bld1241(tMSGBUF *ZMsgBuf, tMSG1241 *Msg)
{
 
  tSHORT index=0;
  
  for(index=5; index<45; index++) ZMsgBuf->word[index] = ZMsgBuf->word[index+2];

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1241                           , ZMsgBuf, 2);     // message number
   PutShort  (40                             , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
                                                   
}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1241 message from the ZMsgBuf.
//
void Show1241(tMSG1241 *Msg)
{
; // whatever
}                                                 

end not needed yet */
                                      
                                           
